<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Expense_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /* ========== Insert data ========== */
    public function insertData($table, $data)
    {
        $this->db->insert($table, $data);
        $returnValue = $this->db->insert_id();
        return $returnValue;
    }

    /* ========== Update data ========== */
    public function updateData($table, $index, $identifier, $data)
    {
        $this->db->where($index, $identifier);
        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    /* ============================================== Expense Category ==================================================== */
    /* ========== Get data ========== */
    function getExpenseCategory()
    {
        $this->db->where('exc_status', 1);
        $query = $this->db->get('expense_category');
        return $query;
    }

    /* ========== Get data By Id ========== */
    function getExpenseCategoryById($exc_id)
    {
        $this->db->where('exc_status', 1);
        $this->db->where('exc_id', $exc_id);
        $query = $this->db->get('expense_category');
        return $query->row();
    }

    /* ============================================== Expense ==================================================== */
    /* ========== Get data ========== */
    function getExpense()
    {
        $this->db->where('ex_status', 1);
        $query = $this->db->get('expense');
        return $query;
    }

    /* ========== Get data By Id ========== */
    function getExpenseById($exc_id)
    {
        $this->db->where('ex_status', 1);
        $this->db->where('ex_id', $exc_id);
        $query = $this->db->get('expense');
        return $query->row();
    }

    /* ========== Get total sum of expense ========== */
    function geTotalSumOfExpense()
    {
        $this->db->where('ex_status', 1);
        $this->db->select("SUM(ex_amount) AS total");
        $query = $this->db->get('expense');
        return $query->row()->total;
    }




    /* ============================================== Expense payments ==================================================== */
    /* ========== get total expense payment data ========== */
    function getTotalExpensePayments()
    {
        $this->db->where('exp_status', 1);
        $this->db->select("SUM(exp_paid_amount) AS total");
        $query = $this->db->get('expense_payment');
        return $query->row()->total;
    }

    /* ========== Get expense payments by expense id ========== */
    function getExpensePaymentsByExpenseId($ex_id)
    {
        $this->db->where('exp_status', 1);
        $this->db->where('exp_ex_id', $ex_id);
        $query = $this->db->get('expense_payment');
        return $query->result();
    }

    /* ========== Get expense payment amount by expense id ========== */
    function geTotalSumAmountByExpenseId($ex_id)
    {
        $this->db->where('exp_status', 1);
        $this->db->where('exp_ex_id', $ex_id);
        $this->db->select("SUM(exp_paid_amount) AS total");
        $query = $this->db->get('expense_payment');
        return $query->row()->total;
    }

    /* ========== Get expense paid amount ========== */
    function geTotalSumPaidAmount()
    {
        $this->db->where('exp_status', 1);
        $this->db->select("SUM(exp_paid_amount) AS total");
        $query = $this->db->get('expense_payment');
        return $query->row()->total;
    }
    /* ========== Get expense payments paid amount ========== */
    function geExpenseWiseTotalPaidAmount($id)
    {
        $this->db->where('exp_status', 1);
        $this->db->where('exp_ex_id', $id);
        $this->db->select("SUM(exp_paid_amount) AS total");
        $query = $this->db->get('expense_payment');
        return $query->row()->total;
    }
}
