<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Home extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('ion_auth_model');
        $this->load->library('upload');
        $this->load->model('client/client_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('purchase/purchase_model');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
        $this->load->model('shed/shed_model');
        $this->load->model('sale/sale_model');
        $this->load->model('expense/expense_model');
        $this->load->model('livestock/livestock_model');
        $this->load->model('food/food_model');
        $this->load->model('report/report_model');
        $this->load->model('settings/settings_model');
        $this->load->model('home_model');
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
    }

    public function index()
    {
        $data = array();
        $data['total_livestock_purchased_amount'] = $this->purchase_model->getTotalLivestockPurchasedAmount();
        $data['foods'] = $this->food_model->getFood();
        $data['settings'] = $this->settings_model->getSettings();
        $data['clients'] = $this->client_model->getClient();
        $data['sheds'] = $this->shed_model->getShed();
        $data['suppliers'] = $this->supplier_model->getData('supplier', 's_status', 1);

        $this->load->view('dashboard', $data); // just the header file
        $this->load->view('home', $data);
        $this->load->view('footer');
    }

    public function permission()
    {
        $this->load->view('permission');
    }
}

/* End of file home.php */
/* Location: ./application/modules/home/controllers/home.php */
