<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /* ============================================== staff ==================================================== */
    // Insert Data
    public function insertData($table, $data)
    {
        $this->db->insert($table, $data);
        $returnValue = $this->db->insert_id();
        return $returnValue;
    }

    // Update Data
    public function updateData($table, $index, $identifier, $data)
    {
        $this->db->where($index, $identifier);
        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Get Data
    function getStaff()
    {
        $this->db->where('sf_status', 1);
        $query = $this->db->get('staff');
        return $query;
    }
    // Get Data By Id
    function getStaffById($sf_id)
    {
        $this->db->where('sf_status', 1);
        $this->db->where('sf_id', $sf_id);
        $query = $this->db->get('staff');
        return $query->row();
    }
}
