<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('supplier_model');
        $this->load->library('upload');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
        $this->load->model('ion_auth_model');
        $this->load->model('settings/settings_model');
        $this->load->model('report/report_model');

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
    }

    public function listSupplier()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['suppliers'] = $this->supplier_model->getData('supplier', 's_status', 1);
        // $data['supplierTypes'] = $this->supplier_model->getData('supplier_type', 'st_status', 1);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('list_supplier', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function insertSupplier()
    {
        $s_id = $this->input->post('s_id');
        $name = $this->input->post('s_name');

        $email = $this->input->post('s_email');
        $address = $this->input->post('s_address');
        $phone = $this->input->post('s_phone');
        $description = $this->input->post('s_description');


        $file_name = $_FILES['s_img_url']['name'];
        $file_name_pieces = explode('_', $file_name);
        $new_file_name = '';
        $count = 1;
        foreach ($file_name_pieces as $piece) {
            if ($count !== 1) {
                $piece = ucfirst($piece);
            }
            $new_file_name .= $piece;
            $count++;
        }
        $config = array(
            'file_name' => $new_file_name,
            'upload_path' => "./uploads/",
            'allowed_types' => "gif|jpg|png|jpeg|pdf",
            'overwrite' => False,
            'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
            'max_height' => "1768",
            'max_width' => "2024"
        );

        if (empty($s_id)) {
            // insert
            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('s_img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    's_img_url' => $img_url,
                    's_name' => $name,
                    's_email' => $email,
                    's_address' => $address,
                    's_phone' => $phone,
                    's_description' => $description,
                    's_status' => 1,
                    's_created_at' => get_current_time(),
                    's_created_by' => $this->ion_auth->user()->row()->user_id
                );
            } else {
                $data = array();
                $data = array(
                    's_name' => $name,
                    's_email' => $email,
                    's_address' => $address,
                    's_phone' => $phone,
                    's_description' => $description,
                    's_status' => 1,
                    's_created_at' => get_current_time(),
                    's_created_by' => $this->ion_auth->user()->row()->user_id
                );
            }
            $this->supplier_model->insertData('supplier', $data);
            redirect('supplier/listSupplier');
        } else {
            // Update
            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('s_img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    's_img_url' => $img_url,
                    's_name' => $name,
                    's_email' => $email,
                    's_address' => $address,
                    's_phone' => $phone,
                    's_description' => $description,
                    's_status' => 1,
                    's_updated_at' => get_current_time(),
                    's_updated_by' => $this->ion_auth->user()->row()->user_id
                );
            } else {
                $data = array();
                $data = array(
                    's_name' => $name,
                    's_email' => $email,
                    's_address' => $address,
                    's_phone' => $phone,
                    's_description' => $description,
                    's_status' => 1,
                    's_updated_at' => get_current_time(),
                    's_updated_by' => $this->ion_auth->user()->row()->user_id
                );
            }
            if (!empty($s_id)) {
                $this->supplier_model->updateData('supplier', 's_id', $s_id, $data);
            }
            redirect('supplier/listSupplier');
        }
    }

    function deleteSupplier()
    {
        $s_id = $this->input->get('s_id');
        $data = array(
            's_status' => 0,
            's_updated_at' => get_current_time(),
            's_updated_by' => $this->ion_auth->user()->row()->user_id
        );
        $this->supplier_model->updateData('supplier', 's_id', $s_id, $data);
        redirect('supplier/listSupplier');
    }

    function editSupplierByJason()
    {
        $id = $this->input->get('s_id');
        $data['suppliers'] = $this->supplier_model->getData('supplier', 's_id', $id)->row();
        echo json_encode($data);
    }





    // End
}

/* End of file supplier.php */
/* Location: ./application/modules/supplier/controllers/supplier.php */
