<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?php echo base_url(); ?>">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="Rizvi">
    <meta name="keyword" content="Php, Livestock, Chicken, Management, Software, Php, CodeIgniter, Accounting">
    <link rel="shortcut icon" href="<?php echo base_url('uploads/avatar/logo11.png'); ?>">
    <title><?php echo $this->router->fetch_class(); ?> | <?php echo lang('livestock'); ?> </title>
    <!-- Bootstrap core CSS -->
    <link href="<?php echo base_url('common/css/bootstrap.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('common/css/bootstrap-reset.css'); ?>" rel="stylesheet">
    <!--font-awesome css-->
    <!-- 4.07 -->
    <link href="<?php echo base_url('common/assets/font-awesome-4.7.0/css/font-awesome.min.css'); ?>" rel="stylesheet" />
    <!-- 6.1.1 -->
    <link href="<?php echo base_url('common/assets/font-awesome/css/all.min.css'); ?>" rel="stylesheet" />
    <link href="<?php echo base_url('common/assets/font-awesome/css/fontawesome.css'); ?>" rel="stylesheet" />

    <link rel="stylesheet" href="<?php echo base_url('common/assets/data-tables/DT_bootstrap.css'); ?>" />
    <!-- Custom styles for this template -->
    <link href="<?php echo base_url('common/css/style.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('common/css/custom.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('common/css/style-responsive.css'); ?>" rel="stylesheet" />

    <link rel="stylesheet" href="<?php echo base_url('common/assets/bootstrap-datepicker/css/datepicker.css'); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('common/assets/bootstrap-daterangepicker/daterangepicker-bs3.css'); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('common/assets/bootstrap-datetimepicker/css/datetimepicker.css'); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('common/assets/jquery-multi-select/css/multi-select.css'); ?>" />
    <link href="<?php echo base_url('common/css/invoice-print.css'); ?>" rel="stylesheet" media="print">
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('common/assets/select2/select2.min.css'); ?>" />


    <!-- jQuery UI -->
    <link rel="stylesheet" href="<?php echo base_url('common/css/jquery-ui-1.11.2.css'); ?>">

    <link rel="stylesheet" href="<?php echo base_url('common/css/toastr.min.css'); ?>">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 tooltipss and media queries -->
    <!--[if lt IE 9]>
          <script src="js/html5shiv.js"></script>
          <script src="js/respond.min.js"></script>
        <![endif]-->
</head>

<body>
    <section id="container" class="">
        <!--header start-->
        <header class="header white-bg">
            <div class="sidebar-toggle-box">
                <div data-original-title="Toggle Navigation" data-placement="right" class="fa fa-bars tooltips"></div>
            </div>
            <!--logo start-->
            <a class="logo"><?php echo lang('live'); ?><span><?php echo lang('stock'); ?></span></a>
            <!--logo end-->
            <div class="nav notify-row">
                <header class="panel-heading top_menu_title">
                    <?php echo $settings->system_vendor; ?>
                </header>
            </div>
            <div class="top-nav ">

                <!-- </?php
                $message = $this->session->flashdata('feedback');
                if (!empty($message)) {
                ?>
                    <div class="success_flash_message pull-left"><i class="fa fa-check"></i> <?php echo $message; ?></div>
                </?php } ?> -->

                <ul class="nav pull-right top-menu">
                    <!-- user login dropdown start-->
                    <li class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <?php if ($settings->img_url) { ?>
                                <img alt="" src="<?php echo $settings->img_url; ?>" width="21" height="23">
                            <?php  } else { ?>
                                <img alt="" src="<?php echo base_url('uploads/avatar/alter-image.png'); ?>" width="21" height="23">
                            <?php  } ?>
                            <span class="username"><?php echo $this->ion_auth->user()->row()->username; ?></span>
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu extended logout">
                            <div class="log-arrow-up"></div>
                            <?php if (!$this->ion_auth->in_group('admin')) { ?>
                                <li><a><i class="fa fa-dashboard"></i> <?php echo lang('dashboard'); ?></a></li>
                            <?php } ?>
                            <li><a href="<?php echo base_url('profile'); ?>"><i class=" fa fa-suitcase"></i><?php echo lang('profile'); ?></a></li>
                            <?php if ($this->ion_auth->in_group('admin')) { ?>
                                <li><a href="<?php echo base_url('settings'); ?>"><i class="fa fa-cog"></i> <?php echo lang('settings'); ?></a></li>
                            <?php } ?>

                            <li><a><i class="fa fa-user"></i> <?php echo $this->ion_auth->get_users_groups()->row()->name ?></a></li>
                            <li><a href="<?php echo base_url('auth/logout'); ?>"><i class="fa fa-key"></i> <?php echo lang('logout'); ?></a></li>
                        </ul>
                    </li>
                    <!-- user login dropdown end -->
                </ul>
            </div>

        </header>
        <!--header end-->
        <!--sidebar start-->
        <aside>
            <div id="sidebar" class="nav-collapse ">
                <!-- sidebar menu start-->
                <ul class="sidebar-menu" id="nav-accordion">
                    <!-- ============== dashboard ============== -->
                    <li>
                        <a href="">
                            <i class="fa-solid fa-house"></i>
                            <span><?php echo lang('dashboard'); ?></span>
                        </a>
                    </li>
                    <!-- ============== /.dashboard ============== -->

                    <!-- ============== Livestock ============== -->
                    <li>
                        <a href="<?php echo base_url('livestock/addLivestock'); ?>">
                            <i class="fa-solid fa-people-roof"></i>
                            <span><?php echo lang('livestock'); ?></span>
                        </a>
                    </li>
                    <!-- ==============/.Livestock ============== -->

                    <!-- ============== Purchase ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="<?php echo base_url('purchase') ?>">
                                <i class="fa fa-money"></i>
                                <span><?php echo lang('purchase'); ?></span>
                            </a>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Purchase ============== -->

                    <!-- ============== Shed ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa-solid fa-house-chimney"></i>
                                <span><?php echo lang('shed'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('shed/addShed'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('shed'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('purchase/livestockAssignToShed') ?>"><i class="fa-solid fa-circle-arrow-right"></i> <?php echo lang('assign_to_shed'); ?></a></li>
                                <li><a href="<?php echo base_url('shed/listDeath'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('death'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('shed/listShedWiseLivestockTransfer'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('transfer'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Shed ============== -->

                    <!-- ============== Vaccine ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-medkit"></i>
                                <span><?php echo lang('vaccine'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('vaccine'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('vaccine'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('vaccine/listVaccinatedShed') ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('vaccination_schedule'); ?></span></a></li>
                                <li><a href="<?php echo base_url('vaccine/listVaccinePurchase') ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('vaccine_purchase'); ?></span></a></li>
                                <li><a href="<?php echo base_url('vaccine/listVaccineRoute') ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('routing'); ?></span></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Vaccine ============== -->

                    <!-- ============== Food ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa-solid fa-bowl-rice"></i>
                                <span><?php echo lang('food_history'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('food/listFood'); ?>"><i class="fa-solid fa-circle-arrow-right"></i> <?php echo lang('food'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('food/listFoodStock') ?>"><i class="fa-solid fa-circle-arrow-right"></i> <?php echo lang('food_stock'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('food/listFoodPurchase'); ?>"><i class="fa-solid fa-circle-arrow-right"></i> <?php echo lang('food_purchase'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Food ============== -->

                    <!-- ============== Product ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?php echo lang('production'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('product/listProduct') ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('production'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('product/listProductCategory') ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('production'); ?> <?php echo lang('category'); ?></span></a></li>
                                <li><a href="<?php echo base_url('product/listLivestockReproduction') ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('reproduction'); ?> <?php echo lang('list'); ?></span></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Product ============== -->

                    <!-- ============== Sale ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-money"></i>
                                <span><?php echo lang('sales'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('sale/listSale') ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('livestock'); ?> <?php echo lang('sales'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('sale/listProductSale') ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('product'); ?> <?php echo lang('sales'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Sale ============== -->

                    <!-- ============== Payments Module ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-medkit"></i>
                                <span><?php echo lang('payments'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('payments/listSupplierPayments'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('supplier'); ?></a></li>
                                <li><a href="<?php echo base_url('payments/listClientPayments'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('client'); ?></a></li>
                                <li><a href="<?php echo base_url('payments/listStaffPayments'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('staff'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /. Payments Module ============== -->

                    <!-- ============== Expense ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-money"></i>
                                <span><?php echo lang('expenses'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('expense/listExpense'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('expenses'); ?> <?php echo lang('list'); ?></a></li>
                                <li><a href="<?php echo base_url('expense/listExpenseCategory'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><span><?php echo lang('category'); ?></span></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Expense ============== -->

                    <!-- ============== Report ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa-solid fa-chart-column"></i>
                                <span><?php echo lang('report'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('report/viewLivestockPurchaseReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('purchase'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewLivestockSaleReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('sale'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewLivestockDeathReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('death'); ?></a></li>
                                <!-- <li><a href="</?php echo base_url('report/viewLivestockStockReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i></?php echo lang('stock'); ?></a></li> -->
                                <li><a href="<?php echo base_url('report/viewFoodStockReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('food'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewVaccineStockReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('vaccine'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewProductStockReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('production'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewSupplierReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('supplier'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewClientReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('client'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewStaffReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('staff'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewExpenseReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('other'); ?> <?php echo lang('expense'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewShedAnalysisReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('shed_analysis'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewBatchAnalysisReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('batch_analysis'); ?></a></li>
                                <li><a href="<?php echo base_url('report/viewFinancialReport'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('finance'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Report ============== -->

                    <!-- ============== Supplier ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-users"></i>
                                <span><?php echo lang('supplier'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('supplier/listSupplier'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('supplier'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Supplier ============== -->

                    <!-- ============== Client ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa-solid fa-users-viewfinder"></i>
                                <span><?php echo lang('client'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('client/listClient'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('client'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Client ============== -->

                    <!-- ============== Staff ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa-solid fa-people-group"></i>
                                <span><?php echo lang('staff'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">

                                <li><a href="<?php echo base_url('staff/listStaff'); ?>"><i class="fa-solid fa-circle-arrow-right"></i><?php echo lang('staff'); ?> <?php echo lang('list'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Staff ============== -->

                    <!-- ============== Settings ============== -->
                    <?php if ($this->ion_auth->in_group('admin')) { ?>
                        <li class="treeview">
                            <a href="">
                                <i class="fa fa-gears"></i>
                                <span><?php echo lang('settings'); ?></span>
                                <span class="pull-right-container">
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="<?php echo base_url('settings'); ?>"><i class="fa fa-gear "></i><span><?php echo lang('settings'); ?></span></a></li>
                                <li><a href="<?php echo base_url('settings/listUnit'); ?>"><i class="fa fa-balance-scale" aria-hidden="true"></i><?php echo lang('unit_setup'); ?></a></li>
                                <li><a href="<?php echo base_url('settings/language'); ?>"><i class="fa fa-wrench"></i><?php echo lang('language'); ?> <?php echo lang('settings'); ?></a></li>
                                <li><a href="<?php echo base_url('settings/backups'); ?>"><i class="fa fa-cloud-download"></i><?php echo lang('backups'); ?></a></li>
                            </ul>
                        </li>
                    <?php } ?>
                    <!-- ============== /.Settings ============== -->

                    <!-- ============== Profile ============== -->
                    <li>
                        <a href="<?php echo base_url('profile'); ?>">
                            <i class="fa fa-user"></i>
                            <span> <?php echo lang('profile'); ?> </span>
                        </a>
                    </li>
                    <!-- ============== /.Profile ============== -->

                </ul>
                <!-- sidebar menu end-->
            </div>
        </aside>
        <!--sidebar end-->