<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="row">
            <div class="col-md-12">
                <!-- row 1 -->
                <div class="row state-overview">
                    <!-- Livestock Purchase amount -->
                    <a href="<?php echo base_url('purchase'); ?>">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol blue">
                                    <i class="fa-solid fa-coins"></i>
                                </div>
                                <div class="value">
                                    <h4>
                                        <?php
                                        echo $settings->currency . number_format_currency($total_livestock_purchased_amount, 2); ?> <br>
                                    </h4>
                                    <strong class="text-info"><?php echo lang('livestock_purchase_amount'); ?> </strong>
                                </div>
                            </section>
                        </div>
                    </a>

                    <!-- Other Expense amount -->
                    <a href="#">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol red">
                                    <i class="fa-solid fa-money-bill"></i>
                                </div>
                                <div class="value">
                                    <h4 class="count">
                                        <?php
                                        $foodPurchaseAmount = $this->report_model->getSumData('food_purchase_summary', 'fdps_grand_total', ['fdps_status' => 1]);
                                        $vaccinePurchaseAmount = $this->report_model->getSumData('vaccine_purchase_summary', 'vps_grand_total', ['vps_status' => 1]);
                                        $expenseAmount = $this->report_model->getSumData('expense', 'ex_amount', ['ex_status' => 1]);
                                        $otherExpense = $foodPurchaseAmount + $vaccinePurchaseAmount + $expenseAmount;
                                        echo $settings->currency . number_format_currency($otherExpense, 2);
                                        ?> </br>
                                    </h4>
                                    <strong class="text-info"><?php echo lang('other_expense'); ?> </strong>
                                </div>
                            </section>
                        </div>
                    </a>

                    <!-- Livestock Sale Sale amount -->
                    <a href="#">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol terques">
                                    <i class="fa-solid fa-money-bill"></i>
                                </div>
                                <div class="value">
                                    <h4 class="count2">
                                        <?php
                                        $totalSaleAmount = $this->sale_model->getTotalLivestockSaleAmount() + $this->sale_model->getTotalProductSaleAmount();
                                        echo $settings->currency . number_format_currency($totalSaleAmount, 2); ?> </br>
                                    </h4>
                                    <strong class="text-info"> <?php echo lang('livestock_sale_amount'); ?> </strong>
                                </div>
                            </section>
                        </div>
                    </a>
                    <!-- product Sale amount -->
                    <a href="<?php echo base_url('purchase'); ?>">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol yellow">
                                    <i class="fa-solid fa-money-bill"></i>
                                </div>
                                <div class="value">
                                    <h4>
                                        <?php $productSaleAmount = $this->report_model->getSumData('product_sale_summary', 'prss_grand_total', ['prss_status' => 1]);
                                        echo $settings->currency . number_format_currency($productSaleAmount, 2);
                                        ?> <br>
                                    </h4>
                                    <strong class="text-info"> <?php echo lang('product_sale_amount'); ?></strong>
                                </div>
                            </section>
                        </div>
                    </a>
                </div>
                <!-- row 2 -->
                <!-- Total Livestock -->
                <div class="row state-overview">
                    <a href="<?php echo base_url('purchase/index') ?>">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol red">
                                    <i class="fa-solid fa-people-roof"></i>
                                </div>
                                <div class="value">
                                    <h4 class=" count2">
                                        <?php
                                        $totalBirthQuantity = $this->report_model->getSumData('live_assigned_shed_summary', 'lshs_assign_total_quantity', ['lshs_status' => 1, 'lshs_type' => 2]);
                                        $purQ = $this->report_model->getTotalPurchaseSubTotal('purv_quantity');
                                        $saleQ = $this->report_model->getTotalLivestockSaleQuantity('lssv_quantity');
                                        $deathQ = $this->report_model->getTotalDeath('ld_death_quantity');
                                        $inStockQuantity = ($purQ + $totalBirthQuantity) - ($saleQ + $deathQ);
                                        if ($inStockQuantity) {
                                            echo number_format_currency($inStockQuantity, 0);
                                        } else {
                                            echo 0;
                                        }
                                        ?>
                                    </h4>
                                    <strong class="text-info"><?php echo lang('total_livestock'); ?> </strong>
                                </div>
                            </section>
                        </div>
                    </a>

                    <!-- Purchase Amount Today -->
                    <a href="">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol terques">
                                    <i class="fa-solid fa-money-bill"></i>
                                </div>
                                <div class="value">
                                    <h4 class="count2"> <?php
                                                        $livestockPurchaseAmountToday = $this->report_model->getSumData('livestock_purchase_summary', 'purs_sub_total', ['purs_status' => 1, 'purs_date' => date("Y-m-d")]);
                                                        $foodPurchaseAmountToday = $this->report_model->getSumData('food_purchase_summary', 'fdps_grand_total', ['fdps_status' => 1, 'fdps_date' => date("Y-m-d")]);
                                                        $vaccinePurchaseAmountToday = $this->report_model->getSumData('vaccine_purchase_summary', 'vps_grand_total', ['vps_status' => 1, 'vps_date' => date("Y-m-d")]);
                                                        $expenseAmountToday = $this->report_model->getSumData('expense', 'ex_amount', ['ex_status' => 1, 'ex_date' => date("Y-m-d")]);
                                                        $otherExpenseToday = $livestockPurchaseAmountToday + $foodPurchaseAmountToday + $vaccinePurchaseAmountToday + $expenseAmountToday;
                                                        echo $settings->currency . number_format_currency($otherExpenseToday, 2);
                                                        ?></h4>
                                    <strong class="text-info"><?php echo lang('purchase_amount_today'); ?></strong>
                                </div>
                            </section>
                        </div>
                    </a>

                    <!-- Sale Amount Today -->
                    <a href="#">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol yellow">
                                    <i class="fa-solid fa-money-bill"></i>
                                </div>
                                <div class="value">
                                    <h4 class=" count4"> <?php
                                                            $livestockSaleAmountToday = $this->report_model->getSumData('livestock_sale_summary', 'lsss_grand_total', ['lsss_status' => 1, 'lsss_date' => date("Y-m-d")]);
                                                            $productSaleAmountToday = $this->report_model->getSumData('product_sale_summary', 'prss_grand_total', ['prss_status' => 1, 'prss_date' => date("Y-m-d")]);
                                                            $todaySaleAmount = $livestockSaleAmountToday + $productSaleAmountToday;
                                                            echo $settings->currency . number_format_currency($todaySaleAmount, 2);

                                                            ?></h4>
                                    <strong class="text-info"><?php echo lang('sale_amount_today'); ?></strong>
                                </div>
                            </section>
                        </div>
                    </a>

                    <!-- Today new livestock -->
                    <a href="#">
                        <div class="col-lg-3 col-sm-6">
                            <section class="panel card__box">
                                <div class="symbol blue">
                                    <i class="fa fa-road"></i>
                                </div>
                                <div class="value">
                                    <h4 class="count3">
                                        <?php $todayPurchaseLive = $this->report_model->getTodayPurchaseSubTotal(date("Y-m-d"), 'purv_quantity');
                                        if ($todayPurchaseLive) {
                                            echo $todayPurchaseLive;
                                        } else {
                                            echo 0;
                                        }
                                        ?>
                                    </h4>
                                    <strong class="text-info"><?php echo lang('today_new_livestock'); ?></strong>
                                </div>
                            </section>
                        </div>
                    </a>

                </div>
            </div>
        </div>
        <!-- Payment and received Amount -->
        <?php
        // Payment
        $livestockPurchasePaidAmount = $this->report_model->getSumData('supplier_payment', 'sp_payment_amount', ['sp_status' => 1, 'sp_purchase_type' => 1]);
        $foodPurchasePaidAmount = $this->report_model->getSumData('supplier_payment', 'sp_payment_amount', ['sp_status' => 1, 'sp_purchase_type' => 2]);
        $expensePurchasePaidAmount = $this->report_model->getSumData('expense_payment', 'exp_paid_amount', ['exp_status' => 1]);
        $vaccinePurchasePaidAmount = $this->report_model->getSumData('supplier_payment', 'sp_payment_amount', ['sp_status' => 1, 'sp_purchase_type' => 3]);
        $staffExpenseAmount = $this->report_model->getSumData('staff_payment', 'sfp_payment_amount', ['sfp_status' => 1]);
        $totalPaidAmount = $livestockPurchasePaidAmount + $foodPurchasePaidAmount + $expensePurchasePaidAmount + $vaccinePurchasePaidAmount + $staffExpenseAmount;
        // Received
        $livestockSoldReceivedAmount = $this->report_model->getSumData('client_payment', 'cp_received_amount', ['cp_status' => 1, 'cp_sale_type' => 1]);
        $productSoldReceivedAmount = $this->report_model->getSumData('client_payment', 'cp_received_amount', ['cp_status' => 1, 'cp_sale_type' => 2]);

        $totalReceivedAmount = $livestockSoldReceivedAmount + $productSoldReceivedAmount;

        ?>

        <div class="row">
            <!-- Income Expense Chart -->
            <div class="col-lg-3">
                <section class="panel custom__table">
                    <div class="panel-body" style="text-align: center;">
                        <div id="incomeExpenseStatement"></div>

                    </div>
                </section>
            </div>
            <!-- Livestock Stock chart -->
            <div class="col-lg-6">
                <section class="panel">
                    <div class="panel-body">
                        <div id="livestockStockQuantity"></div>
                    </div>
                </section>
            </div>
            <div class="col-lg-3">
                <section class="panel">
                    <div class="panel-body">
                        <div class="new__card">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo lang('name'); ?></th>
                                            <th><?php echo lang('quantity'); ?></th>
                                            <th><?php echo lang('actions'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="table__cells">
                                                <?php echo lang('total_supplier'); ?> </h4>
                                            </td>
                                            <td class="table__cells"><?php echo $this->report_model->getCountRow('supplier', 's_id', ['s_status' => 1]); ?></td>
                                            <td class="table__cells"><a href="<?php echo base_url('supplier/listSupplier'); ?>"><button class="badge btn-primary"><i class="fa-solid fa-eye"></i> <?= lang('view') ?></button></a></td>
                                        </tr>
                                        <tr>
                                            <td class="table__cells">
                                                <?php echo lang('total_clients'); ?></h4>
                                            </td>
                                            <td class="table__cells"><?php echo $this->report_model->getCountRow('client', 'c_id', ['c_status' => 1]); ?></td>
                                            <td class="table__cells"><a href="<?php echo base_url('client/listClient'); ?>"><button class="badge btn-primary"><i class="fa-solid fa-eye"></i> <?= lang('view') ?></button></button></a></td>
                                        </tr>
                                        <tr>
                                            <td class="table__cells">
                                                <?php echo lang('total_staff'); ?></h4>
                                            </td>
                                            <td class="table__cells"><?php echo $this->report_model->getCountRow('staff', 'sf_id', ['sf_status' => 1]); ?></td>
                                            <td class="table__cells"><a href="<?php echo base_url('staff/listStaff'); ?>"><button class="badge btn-primary"><i class="fa-solid fa-eye"></i> <?= lang('view') ?></button></button></a></td>
                                        </tr>
                                        <tr>
                                            <td class="table__cells">
                                                <?php echo lang('total_shed'); ?></h4>
                                            </td>
                                            <td class="table__cells"><?php echo $this->report_model->getCountRow('shed', 'sh_id', ['sh_status' => 1]); ?></td>
                                            <td class="table__cells"><a href="<?php echo base_url('shed/addShed'); ?>"><button class="badge btn-primary"><i class="fa-solid fa-eye"></i> <?= lang('view') ?></button></button></a></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>


        <div class="row">
            <!-- Shed And Batch Report with collapse -->
            <div class="col-lg-6">
                <div class="faq_container">
                    <div class="">
                        <div class="widget__heading"><i class="fa-solid fa-network-wired"></i> <?php echo lang('shed_batch_wise_stock_quantity'); ?></div>
                        <div id="showall" class="faq_qtn showall"><?php echo lang('show_all'); ?></div>
                        <div id="hideall" class="faq_qtn hideall"><?php echo lang('hide_all'); ?></div>
                    </div>
                    <ul class="faq">
                        <?php
                        if ($sheds) {
                            foreach ($sheds as $shed) {
                                $assignedBatchesByShedId = $this->shed_model->getAssignedBatchesByShedId($shed->sh_id);
                        ?>
                                <li>
                                    <h4 class="faq_qtn"><?= $shed->sh_no; ?>: <?= $shed->sh_title; ?></h4>
                                    <div class="response" style="overflow-x:auto;">
                                        <p class="para">
                                            <?php if ($assignedBatchesByShedId) { ?>
                                        <table class="table table-striped table-hover table-bordered ">
                                            <thead>
                                                <tr>
                                                    <th><?php echo lang('batch'); ?> </th>
                                                    <th><?php echo lang('livestock'); ?> </th>
                                                    <th><?php echo lang('variant'); ?> </th>
                                                    <th><?php echo lang('assigned'); ?> (<?= $settings->unit ?>) </th>
                                                    <th><?php echo lang('sold'); ?> (<?= $settings->unit ?>) </th>
                                                    <th><?php echo lang('death'); ?> (<?= $settings->unit ?>) </th>
                                                    <th><?php echo lang('in_stock'); ?> (<?= $settings->unit ?>)</th>
                                                    <th><?php echo lang('status'); ?> </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                foreach ($assignedBatchesByShedId as $value) {
                                                ?>
                                                    <tr class="over__flow__table">
                                                        <td><strong><?= $value->lshs_batch_id ?>: <?= $value->lshs_batch_title ?></strong></td>
                                                        <td><?= $this->livestock_model->getLivestockById($this->purchase_model->getAssignedLivestockValueDataBySummaryId($value->lshs_id)->lsh_purv_ls_id)->ls_name ?></td>
                                                        <td><?= $this->livestock_model->getLivestockTypeById($this->purchase_model->getAssignedLivestockValueDataBySummaryId($value->lshs_id)->lsh_purv_lst_id)->lst_title ?></td>
                                                        <td><?php echo $totalAssignedQuantity = $value->lshs_assign_total_quantity ?></td>
                                                        <td><?php echo $totalSoldQuantity  = $this->sale_model->getShedAndBatchWiseLivestockSaleQuantity($shed->sh_id, $value->lshs_batch_id, $this->purchase_model->getAssignedLivestockValueDataBySummaryId($value->lshs_id)->lsh_purv_ls_id, $this->purchase_model->getAssignedLivestockValueDataBySummaryId($value->lshs_id)->lsh_purv_lst_id); ?></td>
                                                        <td><?php echo $totalDeathQuantity = $this->shed_model->getDeathLivestockSumByShedAndBatch($shed->sh_id, $value->lshs_batch_id); ?></td>
                                                        <td><?php echo $inStock = $totalAssignedQuantity - ($totalSoldQuantity + $totalDeathQuantity); ?></td>
                                                        <td>
                                                            <?php if ($value->lshs_active_status == 0) { ?>
                                                                <button class="button bg-primary-light"><?php echo lang('running'); ?></button>
                                                            <?php } else { ?>
                                                                <button class="button bg-success-light"><?php echo lang('completed'); ?></button>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>

                                        </table>
                                    <?php  } else { ?>
                                        <table class="table table-striped table-hover table-bordered">
                                            <tr class="text-center">
                                                <td><strong class="text-danger"><?php echo lang('sorry'); ?>:</strong> <?php echo lang('no_result_found_under_this'); ?> (<strong><?= $shed->sh_no; ?>: <?= $shed->sh_title; ?></strong>) <?php echo lang('sheds'); ?>.</td>
                                            </tr>
                                        </table>
                                    <?php  } ?>
                                    </p>
                                    </div>
                                </li>
                            <?php }
                        } else { ?>
                            <table class="table bg-info-light">
                                <tr>
                                    <td class="text-center">
                                        <div class="blank_collapse_height">
                                            <h3><?= lang('no_data_found'); ?></h3>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        <?php  } ?>
                    </ul>
                </div>
            </div>

            <!-- Food Stock -->
            <div class="col-lg-6">
                <section class="panel custom__table">
                    <header class="panel-heading panel__heading__white">
                        <i class="fa fa-sitemap"></i> <?php echo lang('food_stock_lists'); ?>
                    </header>
                    <div class="panel-body">
                        <div style="overflow-x:auto;">
                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th><?php echo lang('serialNo'); ?></th>
                                        <th><?php echo lang('food_name'); ?></th>
                                        <th><?php echo lang('total_purchased'); ?></th>
                                        <th><?php echo lang('distribute'); ?></th>
                                        <th><?php echo lang('wasted'); ?> </th>
                                        <th><?php echo lang('in_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $serial = 0;
                                    foreach ($foods as $food) {
                                        $serial++;
                                    ?>
                                        <tr>
                                            <td><?= $serial ?></td>
                                            <td><?= $food->fds_food_title ?></td>
                                            <td><?php echo $purchaseFood = $this->food_model->getFoodPurchaseWeightByFoodId($food->fds_id, 'fdpv_quantity');
                                                if ($purchaseFood) {
                                                    $unit = $this->settings_model->getUnitById($food->fds_unit_id);
                                                    if ($unit) {
                                                        echo ' ' .  $unit->un_name;
                                                    }
                                                }
                                                ?>
                                            </td>
                                            <td><?php echo $feed = $this->food_model->getFoodDistributedWeightByFoodId($food->fds_id, 'fddv_distributed_quantity');
                                                if ($feed) {
                                                    if ($unit) {
                                                        echo  ' ' . $unit->un_name;
                                                    }
                                                }
                                                ?></td>
                                            <td><?php echo $wastedFood = $this->food_model->getFoodWastedByFoodId($food->fds_id, 'fdw_quantity');
                                                if ($wastedFood) {
                                                    if ($unit) {
                                                        echo ' ' . $unit->un_name;
                                                    }
                                                }
                                                ?></td>
                                            <td><?php
                                                $stillInStock = $purchaseFood - $feed - $wastedFood;
                                                if ($stillInStock) {
                                                    if ($unit) {
                                                        echo  $stillInStock . ' ' . $unit->un_name;
                                                    }
                                                }
                                                ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<!--main content end-->
<!--footer start-->


<script src="<?php echo base_url('common/assets/apexChart/apexchart.js'); ?>"></script>
<script src="<?php echo base_url('common/js/jquery-1.11.1.min.js'); ?>"></script>
<!-- Collapse -->
<script>
    jQuery(function() {
        var $ = jQuery;
        var faqTitle = $(".faq h4");
        var answerFaq = $(".response");
        faqTitle.click(function(e) {
            e.preventDefault();
            $(this).toggleClass('titleopen').next().slideToggle().toggleClass('open-close');
        });
        $("#showall").click(function(e) {
            e.preventDefault();
            faqTitle.addClass('titleopen');
            answerFaq.slideDown().addClass('open-close');
        });
        $("#hideall").click(function(e) {
            e.preventDefault();
            faqTitle.removeClass('titleopen');
            answerFaq.slideUp().removeClass('open-close');
        });
    });
</script>

<!-- Expense Income -->
<script>
    var colors = ['#FF0000', '#008000'];
    var options = {
        series: [<?php if ($totalPaidAmount) {
                        echo $totalPaidAmount;
                    } else {
                        echo 0;
                    }
                    ?>, <?php if ($totalReceivedAmount) {
                            echo $totalReceivedAmount;
                        } else {
                            echo 0;
                        }
                        ?>],
        chart: {
            width: 380,
            height: 300,
            type: 'donut',
        },

        plotOptions: {
            pie: {
                startAngle: -90,
                endAngle: 270,
            }
        },
        dataLabels: {
            enabled: true
        },
        fill: {
            type: 'gradient',
        },
        labels: ["<?= lang('expense'); ?>: <?php echo $settings->currency . number_format_currency($totalPaidAmount, 2); ?>", '<?= lang('income'); ?>: <?php echo $settings->currency . number_format_currency($totalReceivedAmount, 2); ?>'],
        title: {
            text: '<?= lang('income_expense_statement'); ?>'
        },
        colors: colors,
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200,
                    toolbar: {
                        show: true
                    },

                },
            }
        }],
        legend: {
            show: true,
            position: 'bottom',
            horizontalAlign: 'center'
        },

    };

    var chart = new ApexCharts(document.querySelector("#incomeExpenseStatement"), options);
    chart.render();
</script>

<!-- Stock Chart -->
<script>
    var color1 = ['#008FFB', '#008000', '#FEB019', ' #FF4560 ', ' #564299'];
    var color2 = ['#008FFB', '#FEB019', ' #FF4560 ', ' #564299'];
    var options1 = {
        series: [{
            name: [],
            data: [
                <?php if ($totalBirthQuantity) { ?>
                    <?php echo $purQ; ?>, <?php echo $totalBirthQuantity; ?>, <?php echo $saleQ; ?>, <?php echo $deathQ; ?>, <?php echo $inStockQuantity; ?>
                <?php } else { ?>
                    <?php if ($purQ) {
                        echo $purQ;
                    } else {
                        echo 0;
                    }
                    ?>, <?php if ($saleQ) {
                            echo $saleQ;
                        } else {
                            echo 0;
                        } ?>, <?php if ($deathQ) {
                                    echo $deathQ;
                                } else {
                                    echo 0;
                                } ?>, <?php if ($inStockQuantity) {
                                            echo $inStockQuantity;
                                        } else {
                                            echo 0;
                                        } ?>
                <?php } ?>
            ]
        }],
        chart: {
            type: 'bar',
            height: 250,
            events: {
                click: function(chart, w, e) {}
            },
        },
        plotOptions: {
            bar: {
                borderRadius: 10,
                horizontal: false,
                columnWidth: '55%',
                endingShape: 'rounded',
                distributed: true
            },
        },

        dataLabels: {
            enabled: true,
        },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        xaxis: {
            categories: [
                <?php if ($totalBirthQuantity) { ?> '<?= lang('purchase'); ?>', '<?= lang('reproduction'); ?>', '<?= lang('sale'); ?>', '<?= lang('death'); ?>', '<?= lang('stock'); ?>'
                <?php } else { ?> '<?= lang('purchase'); ?>', '<?= lang('sale'); ?>', '<?= lang('death'); ?>', '<?= lang('stock'); ?>'
                <?php } ?>
            ],
            labels: {
                style: {
                    colors: <?php if ($totalBirthQuantity) {
                                echo "color1";
                            } else {
                                echo "color2";
                            }
                            ?>,

                    fontSize: '12px'
                }
            },
            tickPlacement: 'on'
        },
        yaxis: {
            title: {
                text: ''
            }
        },
        fill: {
            opacity: 1,
        },
        title: {
            text: '<?php echo lang('livestock') . ' ' . lang('stock_information'); ?>'
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return "" + val + " <?= $settings->unit; ?>"
                }
            }
        }
    };

    var chart = new ApexCharts(document.querySelector("#livestockStockQuantity"), options1);
    chart.render();
</script>