<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sale_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    /* ==================== New Code By Rimon ==================== */
    function insertData($table, $data)
    {
        $this->db->insert($table, $data);
        $returnValue = $this->db->insert_id();
        return $returnValue;
    }

    // Update Data
    public function updateData($table, $index, $identifier, $data)
    {
        $this->db->where($index, $identifier);
        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }


    function getLivestockSale()
    {
        $this->db->where('lsss_status', 1);
        $this->db->order_by('lsss_id', 'desc');
        $query = $this->db->get('livestock_sale_summary');
        return $query->result();
    }

    function getLivestockSaleById($id)
    {
        $this->db->where('lsss_status', 1);
        $this->db->where('lsss_id', $id);
        $query = $this->db->get('livestock_sale_summary');
        return $query->row();
    }

    function getLivestockSaleValueBySummaryById($id)
    {
        $this->db->where('lssv_status', 1);
        $this->db->where('lssv_lsss_id', $id);
        $query = $this->db->get('livestock_sale_value');
        return $query->result();
    }
    // Livestock Sale
    function getTotalLivestockSumBySaleSummaryId($lsss_id)
    {
        $this->db->where('lssv_status', 1);
        $this->db->where('lssv_lsss_id', $lsss_id);
        $this->db->select('SUM(lssv_quantity) AS total_sum');
        $query = $this->db->get('livestock_sale_value');
        return $query->row()->total_sum;
    }
    // Livestock 
    function getTotalLivestockSaleAmount()
    {
        $this->db->where('lsss_status', 1);
        $this->db->select('SUM(lsss_grand_total) AS total_sum');
        $query = $this->db->get('livestock_sale_summary');
        return $query->row()->total_sum;
    }
    // Products
    function getTotalProductSaleAmount()
    {
        $this->db->where('prss_status', 1);
        $this->db->select('SUM(prss_grand_total) AS total_sum');
        $query = $this->db->get('product_sale_summary');
        return $query->row()->total_sum;
    }


    /* =========================== Shed, batch wise purchase Livestock Quantity =========================== */
    function getShedAndBatchWiseLivestockPurchaseQuantity($shed_id, $batch_id)
    {
        $this->db->where('lshs_sh_id', $shed_id);
        $this->db->where('lshs_batch_id', $batch_id);
        $this->db->where('lshs_status', 1);
        $this->db->select('SUM(lshs_assign_total_quantity) AS total_sum');
        $query = $this->db->get('live_assigned_shed_summary');
        return $query->row()->total_sum;
    }
    /* =========================== Batch wise Sale Livestock Quantity =========================== */
    function getShedAndBatchWiseLivestockSaleQuantity($shed_id, $batch_id, $ls_id, $lst_id)
    {
        $this->db->JOIN('livestock_sale_summary', 'livestock_sale_summary.lsss_id = livestock_sale_value.lssv_lsss_id');
        $this->db->where('lssv_shed_id', $shed_id);
        $this->db->where('lssv_batch_id', $batch_id);
        $this->db->where('lssv_ls_id', $ls_id);
        $this->db->where('lssv_lst_id', $lst_id);
        $this->db->where('lsss_status', 1);
        $this->db->where('lssv_status', 1);
        $this->db->select('SUM(lssv_quantity) AS total_sum');
        $query = $this->db->get('livestock_sale_value');
        return $query->row()->total_sum;
    }
    /* =========================== Batch wise Death Livestock Quantity =========================== */
    function getShedAndBatchWiseLivestockDeathQuantity($ld_sh_id, $batch_id, $ls_id, $lst_id)
    {
        $this->db->where('ld_sh_id', $ld_sh_id);
        $this->db->where('ld_batch_id', $batch_id);
        $this->db->where('ld_purv_ls_id', $ls_id);
        $this->db->where('ld_purv_lst_id', $lst_id);
        $this->db->where('ld_status', 1);
        $this->db->select('SUM(ld_death_quantity) AS total_sum');
        $query = $this->db->get('livestock_death_quantity');
        return $query->result()[0]->total_sum;
    }

    // Livestock Sale
    function getSaleByClientId($client_id)
    {
        $this->db->where('lsss_status', 1);
        $this->db->where('lsss_c_id', $client_id);
        $query = $this->db->get('livestock_sale_summary');
        return $query->result();
    }

    // Product Sale
    function getProductSaleByClientId($client_id)
    {
        $this->db->where('prss_status', 1);
        $this->db->where('prss_c_id', $client_id);
        $query = $this->db->get('product_sale_summary');
        return $query->result();
    }

    // Livestock 
    function getSumClientWiseTotalSaleAmount($client_id)
    {
        $this->db->select('SUM(lsss_grand_total) AS total');
        $this->db->where('lsss_c_id', $client_id);
        $this->db->where('lsss_status', 1);
        $query = $this->db->get('livestock_sale_summary');
        return $query->row()->total;
    }
    // Product
    function getSumClientWiseTotalProductSaleAmount($client_id)
    {
        $this->db->select('SUM(prss_grand_total) AS total');
        $this->db->where('prss_c_id', $client_id);
        $this->db->where('prss_status', 1);
        $query = $this->db->get('product_sale_summary');
        return $query->row()->total;
    }

    // Product stock
    function getProductSoldQuantityByProductId($id, $column)
    {
        $this->db->where('prsv_status', 1);
        $this->db->where('prsv_product_id', $id);
        $this->db->select("SUM($column) AS total_sum");
        $query = $this->db->get('product_sale_value');
        return $query->row()->total_sum;
    }

    /* =========================== Get Only Unique Batch that stored livestock =========================== */
    function getUniqueValueFromAssignedShed()
    {
        $this->db->select('DISTINCT(lsh_batch_id)');
        $this->db->where('lsh_status', 1);
        $query = $this->db->get('live_assigned_shed');
        return $query->result();
    }

    /* =========================== Get Only Unique livestock that stored in shed =========================== */
    function getUniqueValueFromAssignedLivestock()
    {
        $this->db->select('DISTINCT(lsh_purv_ls_id)');
        $this->db->where('lsh_status', 1);
        $query = $this->db->get('live_assigned_shed');
        return $query->result();
    }

    // Livestock Sale Quantity 
    function getTotalSaleLivestockQuantity()
    {
        $this->db->where('lssv_status', 1);
        $this->db->select('SUM(lssv_quantity) AS total_sum');
        $query = $this->db->get('livestock_sale_value');
        return $query->row()->total_sum;
    }

    /* ======================================= Product Sale ======================================= */
    function getProductSale()
    {
        $this->db->where('prss_status', 1);
        $this->db->order_by('prss_id', 'desc');
        $query = $this->db->get('product_sale_summary');
        return $query->result();
    }

    function getProductSaleById($id)
    {
        $this->db->where('prss_status', 1);
        $this->db->where('prss_id', $id);
        $query = $this->db->get('product_sale_summary');
        return $query->row();
    }


    // Product Sale Quantity 
    function getSaleWiseSaleProductQuantity($summary_id, $column)
    {
        $this->db->where('prsv_status', 1);
        $this->db->where('prsv_prss_id', $summary_id);
        $this->db->select("SUM($column) AS total_sum");
        $query = $this->db->get('product_sale_value');
        return $query->row()->total_sum;
    }

    // Product Sale Quantity by assigned id
    function getProductAssignedWiseProductSaleValue($assigned_id, $column)
    {
        $this->db->where('prsv_status', 1);
        $this->db->where('prsv_pra_id', $assigned_id);
        $this->db->select("SUM($column) AS total_sum");
        $query = $this->db->get('product_sale_value');
        return $query->row()->total_sum;
    }
    // Product Sale Quantity 
    function getTotalSaleProductQuantity()
    {
        $this->db->where('prsv_status', 1);
        $this->db->select('SUM(prsv_quantity) AS total_sum');
        $query = $this->db->get('product_sale_value');
        return $query->row()->total_sum;
    }

    // Product Sale Quantity 
    function getProductSaleValueByProductId($summary_id)
    {
        $this->db->where('prsv_status', 1);
        $this->db->where('prsv_prss_id', $summary_id);
        $query = $this->db->get('product_sale_value');
        return $query->result();
    }

    /* =============== Client Invoice =============== */
    // Product Sale Quantity 
    function getProductSaleValueByProductIdClientInvoice($summary_id)
    {
        $this->db->where('prsv_status', 1);
        $this->db->group_by('prsv_product_id');
        $this->db->where('prsv_prss_id', $summary_id);
        $query = $this->db->get('product_sale_value');
        return $query->result();
    }

    function getProductWiseTotalValue($pr_id, $summary_id, $column)
    {
        $this->db->where('prsv_status', 1);
        $this->db->where('prsv_product_id', $pr_id);
        $this->db->where('prsv_prss_id', $summary_id);
        $this->db->select("SUM($column) AS total_sum");
        $query = $this->db->get('product_sale_value');
        return $query->row()->total_sum;
    }

    // shed wise sale
    function getShedWiseSoldLivestock($shed_id)
    {
        $this->db->JOIN('livestock_sale_summary', 'livestock_sale_summary.lsss_id = livestock_sale_value.lssv_lsss_id');
        $this->db->where('lssv_shed_id', $shed_id);
        $this->db->where('lsss_status', 1);
        $this->db->where('lssv_status', 1);
        $this->db->select('SUM(lssv_quantity) AS total_sum');
        $query = $this->db->get('livestock_sale_value');
        return $query->row()->total_sum;
    }



    // End
}
