<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('settings_model');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
        //$this->lang->load('system_syntax', $language);
        $this->load->library('upload');
        $this->load->library('sma');
        $this->load->helper('url');

        //$language = $this->db->get('settings')->row()->language;
        $this->load->model('ion_auth_model');

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function update()
    {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $title = $this->input->post('title');
        $email = $this->input->post('email');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $currency = $this->input->post('currency');
        $unit = $this->input->post('unit');
        $date_format = $this->input->post('date_format');
        $login_title = $this->input->post('login_title');
        $discount = $this->input->post('discount');
        $buyer = $this->input->post('buyer');
        $p_code = $this->input->post('p_code');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating System Name Field
        $this->form_validation->set_rules('name', 'System Name', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating Title Field
        $this->form_validation->set_rules('title', 'Title', 'rtrim|equired|min_length[5]|max_length[100]|xss_clean');
        // Validating Email Field
        $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[5]|max_length[500]|xss_clean');
        // Validating Phone Field           
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[5]|max_length[50]|xss_clean');
        // Validating Currency Field   
        $this->form_validation->set_rules('currency', 'Currency', 'trim|required|min_length[1]|max_length[3]|xss_clean');
        // Validating Unit Field 
        $this->form_validation->set_rules('unit', 'Unit', 'trim|required|min_length[1]|max_length[5]|xss_clean');
        // Validating Date Field 
        $this->form_validation->set_rules('date_format', 'Date Format', 'trim|required|min_length[1]|max_length[10]|xss_clean');
        // Validating login Field 
        $this->form_validation->set_rules('login_title', 'Login Title', 'trim|required|min_length[1]|max_length[100]|xss_clean');


        $file_name = $_FILES['img_url']['name'];
        // x_debug($file_name);
        $file_name_pieces = explode('_', $file_name);
        $new_file_name = '';
        $count = 1;
        foreach ($file_name_pieces as $piece) {
            if ($count !== 1) {
                $piece = ucfirst($piece);
            }
            $new_file_name .= $piece;
            $count++;
        }
        $config = array(
            'file_name' => $new_file_name,
            'upload_path' => "./uploads",
            'allowed_types' => "gif|jpg|png|jpeg|pdf",
            'overwrite' => False,
            'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
            'max_height' => "1768",
            'max_width' => "2024"
        );

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('settings', $data);
            $this->load->view('home/footer'); // just the footer file
        } else {

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);
            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];

                $data = array();
                $data = array(
                    'img_url' => $img_url,
                    'system_vendor' => $name,
                    'title' => $title,
                    'address' => $address,
                    'phone' => $phone,
                    'email' => $email,
                    'currency' => $currency,
                    'unit' => $unit,
                    'date_format' => $date_format,
                    'login_title' => $login_title,
                    'discount' => $discount,
                    'codec_username' => $buyer,
                    'codec_purchase_code' => $p_code
                );
            } else {
                $data = array();
                $data = array(
                    'system_vendor' => $name,
                    'title' => $title,
                    'address' => $address,
                    'phone' => $phone,
                    'email' => $email,
                    'currency' => $currency,
                    'unit' => $unit,
                    'date_format' => $date_format,
                    'login_title' => $login_title,
                    'discount' => $discount,
                    'codec_username' => $buyer,
                    'codec_purchase_code' => $p_code
                );
            }

            $this->settings_model->updateSettings($id, $data);

            // Loading View
            $this->session->set_flashdata('feedback', 'Updated');
            redirect('settings');
        }
    }

    public function language()
    {
        $id = $this->input->post('id');
        $language = $this->input->post('language');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('language', 'Language', 'trim|required|min_length[2]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('language', $data);
            $this->load->view('home/footer'); // just the footer file
        } else {

            //$error = array('error' => $this->upload->display_errors());
            $data = array();
            $data = array(
                'language' => $language
            );

            $this->settings_model->updateSettings($id, $data);

            // Loading View
            $this->session->set_flashdata('feedback', 'Updated');
            redirect('settings/languageSettings');
        }
    }

    function languageSettings()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('language', $data);
        $this->load->view('home/footer');
    }

    function backups()
    {
        $data['files'] = glob('./files/backups/*.zip', GLOB_BRACE);
        $data['dbs'] = glob('./files/backups/*.txt', GLOB_BRACE);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('backups', $data);
        $this->load->view('home/footer');
    }

    function backup_database()
    {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("settings/permission");
        }
        $this->load->dbutil();
        $prefs = array(
            'format' => 'txt',
            'filename' => 'spos_db_backup.sql'
        );
        $back = $this->dbutil->backup($prefs);
        $backup = &$back;
        $db_name = 'db-backup-on-' . date("Y-m-d-H-i-s") . '.txt';
        $save = './files/backups/' . $db_name;
        $this->load->helper('file');
        write_file($save, $backup);
        $this->session->set_flashdata('message', 'Database backup Successfully!');
        redirect("settings/backups");
    }

    function restore_database($dbfile)
    {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("settings/permission");
        }
        $file = file_get_contents('./files/backups/' . $dbfile . '.txt');
        $this->db->conn_id->multi_query($file);
        $this->db->conn_id->close();
        $this->session->set_flashdata('message', 'Restoring of Backup Successfully');
        redirect('settings/backups');
    }

    function download_database($dbfile)
    {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("settings/permission");
        }
        $this->load->library('zip');
        $this->zip->read_file('./files/backups/' . $dbfile . '.txt');
        $name = 'db_backup_' . date('Y_m_d_H_i_s') . '.zip';
        $this->zip->download($name);
        exit();

        redirect('settings/backups');
    }

    function delete_database($dbfile)
    {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("settings/permission");
        }
        unlink('./files/backups/' . $dbfile . '.txt');
        $this->session->set_flashdata('info', 'Deleting of Database Successfully');
        redirect("settings/backups");
    }

    function permission()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('permission', $data);
        $this->load->view('home/footer');
    }




    /* =========================================== Unit =========================================== */

    public function listUnit()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['units'] = $this->settings_model->getUnit();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('list_unit', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function insertUnit()
    {
        $un_id = $this->input->post('un_id');
        $name = $this->input->post('un_name');
        $description = $this->input->post('un_description');
        if (empty($un_id)) {
            $data = array(
                'un_name' => $name,
                'un_description' => $description,
                'un_status' => 1,
                'un_created_at' => get_current_time(),
                'un_created_by' => $this->ion_auth->user()->row()->user_id
            );
            $this->settings_model->insertData('unit', $data);
            redirect('settings/listUnit');
        } else {
            $updateData = array(
                'un_name' => $name,
                'un_description' => $description,
                'un_updated_at' => get_current_time(),
                'un_updated_by' => $this->ion_auth->user()->row()->user_id
            );
            if (!empty($un_id)) {
                $this->settings_model->updateData('unit', 'un_id', $un_id, $updateData);
            }
            redirect('settings/listUnit');
        }
    }

    function editUnitByJason()
    {
        $id = $this->input->get('un_id');
        $data['units'] = $this->settings_model->getUnitById($id);
        echo json_encode($data);
    }

    function deleteUnit()
    {
        $un_id = $this->input->get('un_id');
        $data = array(
            'un_status' => 0,
            'un_updated_at' => get_current_time(),
            'un_updated_by' => $this->ion_auth->user()->row()->user_id
        );
        $this->settings_model->updateData('unit', 'un_id', $un_id, $data);
        redirect('settings/listUnit');
    }
}

/* End of file settings.php */
/* Location: ./application/modules/settings/controllers/settings.php */
