<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('staff_model');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
        $this->load->library('upload');
        $this->load->model('ion_auth_model');
        $this->load->model('settings/settings_model');
        $this->load->model('report/report_model');

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
    }

    /* =========================================== Staff =========================================== */
    public function listStaff()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['staffs'] = $this->staff_model->getStaff();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('list_staff', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function insertStaff()
    {
        $sf_id = $this->input->post('sf_id');
        $name = $this->input->post('sf_name');

        $email = $this->input->post('sf_email');
        $address = $this->input->post('sf_address');
        $phone = $this->input->post('sf_phone');
        $description = $this->input->post('sf_description');


        $file_name = $_FILES['sf_img_url']['name'];
        $file_name_pieces = explode('_', $file_name);
        $new_file_name = '';
        $count = 1;
        foreach ($file_name_pieces as $piece) {
            if ($count !== 1) {
                $piece = ucfirst($piece);
            }
            $new_file_name .= $piece;
            $count++;
        }
        $config = array(
            'file_name' => $new_file_name,
            'upload_path' => "./uploads/",
            'allowed_types' => "gif|jpg|png|jpeg|pdf",
            'overwrite' => False,
            'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
            'max_height' => "1768",
            'max_width' => "2024"
        );

        if (empty($sf_id)) {
            // insert
            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('sf_img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'sf_img_url' => $img_url,
                    'sf_name' => $name,
                    'sf_email' => $email,
                    'sf_address' => $address,
                    'sf_phone' => $phone,
                    'sf_description' => $description,
                    'sf_status' => 1,
                    'sf_created_at' => get_current_time(),
                    'sf_created_by' => $this->ion_auth->user()->row()->user_id
                );
            } else {
                $data = array();
                $data = array(
                    'sf_name' => $name,
                    'sf_email' => $email,
                    'sf_address' => $address,
                    'sf_phone' => $phone,
                    'sf_description' => $description,
                    'sf_status' => 1,
                    'sf_created_at' => get_current_time(),
                    'sf_created_by' => $this->ion_auth->user()->row()->user_id
                );
            }
            $this->staff_model->insertData('staff', $data);
            redirect('staff/listStaff');
        } else {
            // Update
            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('sf_img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'sf_img_url' => $img_url,
                    'sf_name' => $name,
                    'sf_email' => $email,
                    'sf_address' => $address,
                    'sf_phone' => $phone,
                    'sf_description' => $description,
                    'sf_status' => 1,
                    'sf_updated_at' => get_current_time(),
                    'sf_updated_by' => $this->ion_auth->user()->row()->user_id
                );
            } else {
                $data = array();
                $data = array(
                    'sf_name' => $name,
                    'sf_email' => $email,
                    'sf_address' => $address,
                    'sf_phone' => $phone,
                    'sf_description' => $description,
                    'sf_status' => 1,
                    'sf_updated_at' => get_current_time(),
                    'sf_updated_by' => $this->ion_auth->user()->row()->user_id
                );
            }
            if (!empty($sf_id)) {
                $this->staff_model->updateData('staff', 'sf_id', $sf_id, $data);
            }
            redirect('staff/listStaff');
        }
    }

    function deleteStaff()
    {
        $sf_id = $this->input->get('sf_id');
        $data = array(
            'sf_status' => 0,
            'sf_updated_at' => get_current_time(),
            'sf_updated_by' => $this->ion_auth->user()->row()->user_id
        );
        $this->staff_model->updateData('staff', 'sf_id', $sf_id, $data);

        // Payments Delete
        $deletePayments = array(
            'sfp_status' => 0,
            'sfp_updated_at' => get_current_time(),
            'sfp_updated_by' => $this->ion_auth->user()->row()->user_id
        );
        $this->staff_model->updateData('staff_payment', 'sfp_sf_id', $sf_id, $deletePayments);


        redirect('staff/listStaff');
    }

    function editStaffByJason()
    {
        $id = $this->input->get('sf_id');
        $data['staffs'] = $this->staff_model->getStaffById($id);
        echo json_encode($data);
    }


    // End
}

/* End of file staff.php */
/* Location: ./application/modules/staff/controllers/staff.php */
