<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="row">
            <div class="col-md-12">
                <section class="panel">
                    <header class="panel-heading">
                        <i class="fas fa-stream"></i> <?php echo lang('livestocks'); ?> <?php echo lang('list'); ?>
                    </header>
                    <div class="panel-body">
                        <div class="adv-table editable-table">
                            <div class="clearfix">
                                <a data-toggle="modal" href="#myModal">
                                    <div class="btn-group">
                                        <button class="button button-primary">
                                            <i class="fas fa-plus-circle"></i> <?php echo lang('add_new_livestock'); ?>
                                        </button>
                                    </div>
                                </a>


                                <button class="export" onclick="javascript:window.print();"><i class="fa-solid fa-print"></i> <?php echo lang('print'); ?></button>

                                <a data-toggle="modal" href="#informationPopup" class="button button-purple export"><i class="fa-solid fa-circle-question"></i> <?= lang('information'); ?></a>

                            </div>

                            <div class="space15">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6 col-sm-6">
                                        <div class="new__cards card__box">
                                            <div class="col-xs-9">
                                                <?php
                                                $totalPurchaseQuantity = $this->purchase_model->getTotalPurchasedLivestockQuantity();
                                                $livestockReproductionQuantity = $this->report_model->getSumData('live_assigned_shed_summary', 'lshs_assign_total_quantity', ['lshs_type' => 2, 'lshs_status' => 1]);
                                                ?>
                                                <?php if ($livestockReproductionQuantity) { ?>
                                                    <p><?php echo lang('total_purchased'); ?>: <strong><?php echo $totalPurchaseQuantity; ?></strong></p>
                                                    <p><?php echo lang('reproduction'); ?> : <strong><?php echo $livestockReproductionQuantity; ?></strong></p>
                                                <?php } else { ?>
                                                    <p><?php echo lang('total_purchased'); ?></p>
                                                    <h3><?php echo $totalPurchaseQuantity; ?></h3>
                                                <?php } ?>
                                            </div>
                                            <div class="col-xs-3">
                                                <div class="text-right">
                                                    <ul class="social__icon">
                                                        <li class="icon">
                                                            <span><i class="fa-solid fa-cart-shopping"></i></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6">
                                        <div class="new__cards card__box">
                                            <div class="col-xs-8">
                                                <p><?php echo lang('total_assigned_to_shed'); ?> (<?= $settings->unit; ?>)</p>

                                                <h3><?php $totalAssignedQuantity = $this->purchase_model->getTotalLivestockAssignedToShedQuantity();
                                                    if ($totalAssignedQuantity) {
                                                        echo $totalAssignedQuantity;
                                                    } else {
                                                        echo 0;
                                                    }
                                                    ?></h3>

                                            </div>
                                            <div class="col-xs-4">
                                                <div class="text-right">
                                                    <ul class="social__icon">
                                                        <li class="icon">
                                                            <span><i class="fa-solid fa-store"></i></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6">
                                        <div class="new__cards card__box">
                                            <div class="col-xs-8">
                                                <p><?php echo lang('out_of_shed'); ?> (<?= $settings->unit; ?>)</p>

                                                <h3><?php
                                                    $outOfShed = ($totalPurchaseQuantity + $livestockReproductionQuantity) - $totalAssignedQuantity;
                                                    if ($outOfShed) {
                                                        echo $outOfShed;
                                                    } else {
                                                        echo 0;
                                                    }
                                                    ?>
                                                </h3>
                                            </div>
                                            <div class="col-xs-4">
                                                <div class="text-right">
                                                    <ul class="social__icon">
                                                        <li class="icon">
                                                            <span><i class="fa-solid fa-store-slash"></i></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6">
                                        <div class="new__cards card__box">
                                            <div class="col-xs-8">
                                                <p><?php echo lang('total_purchased_amount'); ?></p>

                                                <h3><?php $totalPurAmount = $this->purchase_model->getTotalLivestockPurchasedAmount();
                                                    if ($totalPurAmount) {
                                                        echo "$settings->currency" . number_format($totalPurAmount, 2, ".", ",");
                                                    } else {
                                                        echo 0;
                                                    }
                                                    ?></h3>

                                            </div>
                                            <div class="col-xs-4">
                                                <div class="text-right">
                                                    <ul class="social__icon">
                                                        <li class="icon">
                                                            <span><i class="fa-solid fa-money-bill"></i></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th style="width: 5%;"><?php echo lang('serialNo'); ?></th>
                                        <th style="width: 20%;"><?php echo lang('livestock_id'); ?></th>
                                        <th style="width: 20%;"><?php echo lang('total_purchased'); ?> (<?= $settings->unit ?>)</th>
                                        <th style="width: 15%;"><?php echo lang('variant'); ?></th>
                                        <th style="width: 40%;"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    foreach ($livestocks as $livestock) {
                                        $serial++;
                                    ?>
                                        <tr class="">
                                            <td> <?= $serial; ?></td>
                                            <td> <?php echo $livestock->ls_name; ?></td>
                                            <td><?php $totalLivestockPurchasedQuantity = $this->livestock_model->getLivestockPurchaseQuantityByLivestockId($livestock->ls_id, 'purv_quantity');
                                                if ($totalLivestockPurchasedQuantity) {
                                                    echo $totalLivestockPurchasedQuantity;
                                                } else {
                                                    echo 0;
                                                }
                                                ?></td>
                                            <td><?php
                                                $variant_count = $this->livestock_model->countLivestockVariantByLivestockId($livestock->ls_id);
                                                if ($variant_count) {
                                                    echo $variant_count;
                                                } else {
                                                    echo "0";
                                                }
                                                ?></td>
                                            <td style="width: 35%;">
                                                <button type="button" class="button button-warning editButton" data-toggle="modal" data-id="<?php echo $livestock->ls_id; ?>"><i class="fas fa-edit"></i> <?php echo lang('edit'); ?></button>
                                                <!-- conditional delete -->
                                                <?php
                                                $countDataIfAvailableInPurchase = $this->settings_model->getCountRow('livestock_purchase_value', 'purv_id', ['purv_ls_id' => $livestock->ls_id, 'purv_status' => 1]);
                                                if ($countDataIfAvailableInPurchase  == 0) { ?>
                                                    <a type="button" class="button button-danger" href="<?php echo base_url('') ?>livestock/deleteLivestock?ls_id=<?php echo $livestock->ls_id; ?>" onclick="return confirm('<?= lang('are_you_sure_want_to_delete_this_item'); ?>');"><i class="fa fa-trash"></i> <?php echo lang('delete'); ?></i></a>
                                                <?php } else { ?>
                                                    <button type="button" class="button button-danger" title="<?= lang('this_item_used_another_places'); ?>" disabled><i class="fas fa-trash"></i> <?php echo lang('delete'); ?></button>
                                                <?php } ?>
                                                <!-- /.conditional delete -->

                                                <a ls-id="<?= $livestock->ls_id; ?>" ls-name="<?= $livestock->ls_name; ?>" class="button button-primary addVariantButton"><i class="fas fa-plus-circle"></i> <?php echo lang('ls_add_variant'); ?></i></a>

                                                <a href="<?php echo base_url(''); ?>livestock/viewVariant?ls_id=<?php echo $livestock->ls_id; ?>" class="button button-info"><i class="fas fa-eye"></i> <?php echo lang('ls_view_variant'); ?></i></a>

                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

<!--Add New Livestock-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><strong><i class="fa fa-plus-circle"></i> <?php echo lang('add_new_livestock'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height: 100%;">
                <form role="form" action="<?php echo base_url('livestock/insertLivestock') ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('ls_name'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="ls_name" id="" value='' placeholder="Enter livestock name" required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('description'); ?></label>
                        <textarea name="ls_description" class="form-control" id="" rows="5" placeholder="Enter description" style="height: auto !important;"></textarea>
                    </div>
                    <section class="">
                        <button type="submit" name="submit" class="button button-info submit_button"><?php echo lang('submit'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<!-- Edit Livestock-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><strong><i class="fa fa-edit"></i> <?php echo lang('edit_livestock'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height: 100%;">
                <form role="form" id="livestockEditForm" action="<?php echo base_url('livestock/updateLivestock') ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('ls_name'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="ls_name" id="" value='' placeholder="Enter Title" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('description'); ?></label>
                        <textarea name="ls_description" class="form-control" id="" rows="5" placeholder="Enter Description" style="height: auto !important;"></textarea>
                    </div>

                    <input type="hidden" name="id" value=''>
                    <input type="hidden" name="ls_id" value=''>

                    <section class="">
                        <button type="submit" name="submit" class="button button-info submit_button"><?php echo lang('edit_button'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<!-- Add Variant -->
<div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><strong><i class="fa fa-plus-circle"></i> <?php echo lang('ls_add_new_variant'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height: 100%;">
                <form role="form" action="<?php echo base_url('') ?>livestock/insertLivestockType" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-xs-12">
                            <table class="table table-striped table-hover table-bordered">
                                <tr>
                                    <td width="50%"><?php echo lang('ls_name_variant_modal'); ?></td>
                                    <td width="50%"><span id="ls_name"></span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('ls_type_title'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="lst_title" id="" value='' placeholder="Enter Title" required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('description'); ?></label>
                        <textarea name="lst_description" class="form-control" id="" rows="5" placeholder="Enter Description" style="height: auto !important;"></textarea>
                    </div>
                    <input type="hidden" name="lst_ls_id" value='' id="ls_id">

                    <section class="">
                        <button type="submit" name="submit" class="button button-info submit_button"><?php echo lang('submit'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


<!-- Information Popup-->
<div class="modal fade" id="informationPopup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-dialog-center">
        <div class="modal-content">
            <div class="modal-header bg-purple">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>
                <h4 class="modal-title"><strong><i class="fa-solid fa-circle-info"></i> <?php echo lang('basic_information'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height: 100%;">
                <div class="row">
                    <div class="col-xs-6">
                        <ol class="information__modal__ol">
                            <li>
                                <p><?= lang('livestock_popup_message_one'); ?></p>
                            </li>
                            <li>
                                <p><?= lang('livestock_popup_message_two'); ?></p>
                            </li>
                            <li>
                                <p><?= lang('livestock_popup_message_three'); ?></p>
                            </li>
                            <li>
                                <p><?= lang('livestock_popup_message_four'); ?></p>
                            </li>
                            <li>
                                <p><?= lang('livestock_popup_message_five'); ?></p>
                            </li>
                        </ol>
                    </div>
                    <div class="col-xs-6">
                        <img class="img-square information__modal__image" src="<?php echo base_url('uploads/information/livestock_and_variant.jpg'); ?>" alt="No img">
                    </div>
                </div>
                <section class="text-right">
                    <button type="button" class="button button-purple" data-dismiss="modal"><i class="fa-solid fa-xmark"></i> <?= lang('close'); ?></button>
                </section>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- /.Information Popup-->



<!-- Javascript For Edit Trip -->
<script src="<?php echo base_url('common/js/jquery-1.11.1.min.js'); ?>"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".editButton").click(function(e) {
            e.preventDefault(e);
            // Get the record's ID via attribute  
            var iid = $(this).attr('data-id');
            $.ajax({
                url: 'livestock/editLivestockByJason?ls_id=' + iid,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function(response) {
                // Populate the form fields with the data returned from server
                $('#livestockEditForm').find('[name="ls_id"]').val(response.livestock.ls_id).end()
                $('#livestockEditForm').find('[name="ls_name"]').val(response.livestock.ls_name).end()
                $('#livestockEditForm').find('[name="ls_description"]').val(response.livestock.ls_description).end()
                $('#myModal2').modal('show');
            });
        });

        // Add Livestock Variant 
        $(".addVariantButton").click(function(e) {
            var iid = $(this).attr('ls-id');
            var name = $(this).attr('ls-name');
            $('#myModal3').modal('show');
            $('#ls_id').val(iid);
            $('#ls_name').html(name);
        });


    });
</script>