<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="col-md-12">
            <section class="panel">
                <header class="panel-heading">
                    <i class="fas fa-stream"></i> <?php echo lang('staff_payment_list'); ?>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table ">
                        <div class="clearfix">
                            <a href="<?php echo base_url('staff/listStaff'); ?>">
                                <div class="btn-group">
                                    <button class="button button-primary">
                                        <i class="fa-solid fa-circle-arrow-up"></i> <?= lang('staff'); ?> <?= lang('list'); ?>
                                    </button>
                                </div>
                            </a>
                            <button class="export" onclick="javascript:window.print();"><i class="fa-solid fa-print"></i> <?php echo lang('print'); ?></button>
                        </div>
                        <div class="space15">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <div class="new__cards card__box bg-success-light">
                                        <div class="col-xs-8">
                                            <p><?= lang('total_payment_amount'); ?></p>
                                            <h3><?php $totalPaymentAmount = $this->payments_model->getTotalStaffPaymentAmount('sfp_payment_amount');
                                                if ($totalPaymentAmount) {
                                                    echo $settings->currency . number_format($totalPaymentAmount, 2, '.', ',');
                                                } else {
                                                    echo 0;
                                                }
                                                ?>
                                            </h3>
                                        </div>
                                        <div class="col-xs-4">
                                            <div class="text-right">
                                                <ul class="social__icon">
                                                    <li class="icon">
                                                        <i class="fa-solid fa-money-bill-1"></i>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                </div>
                            </div>

                        </div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th><?= lang('serialNo'); ?>.</th>
                                    <th><?= lang('name'); ?></th>
                                    <th><?= lang('phone'); ?></th>
                                    <th><?= lang('total_payment_amount'); ?></th>
                                    <th><?= lang('last_payment_date'); ?></th>
                                    <th><?= lang('options'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $serial = 0;
                                foreach ($staffs->result() as $list) {
                                    $serial++;
                                ?>
                                    <tr class="">
                                        <td><?= $serial ?></td>
                                        <td> <?= $list->sf_name; ?></td>
                                        <td><?= $list->sf_phone; ?></td>
                                        <td><?php $paymentsTotal = $this->payments_model->getStaffWiseTotalPaymentAndReceivedAmountSum($list->sf_id, 'sfp_payment_amount');
                                            if ($paymentsTotal) {
                                                echo $settings->currency . number_format_currency($paymentsTotal, 2);
                                            } else {
                                                echo 0;
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            $paymentDate = $this->payments_model->getLastPaymentDate($list->sf_id, 'sfp_date');
                                            if ($paymentDate) {
                                                echo $month = date('F Y', strtotime($paymentDate));
                                            }

                                            ?>
                                        </td>
                                        <td>
                                            <a class="" href="<?php echo base_url('') ?>payments/viewStaffWisePayment?sf_id=<?php echo $list->sf_id; ?>"><button type="button" class="button button-info"><i class="fas fa-eye"></i> <?= lang('payment_report'); ?></button></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->